<?php

use App\Http\Controllers\AppendixController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\CertificateController;
use App\Http\Controllers\ClassRoomController;
use App\Http\Controllers\CourseController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\EvaluationController;
use App\Http\Controllers\EvaluationValueController;
use App\Http\Controllers\ExamController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\LessonController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\QuestionController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\Services\Registration;
use App\Http\Controllers\Services\UploadController;
use App\Http\Controllers\StudentsController;
use App\Http\Controllers\StudentSubscribeController;
use App\Http\Controllers\TrainerController;
use App\Http\Controllers\UploadedEvaluationController;
use App\Http\Controllers\UploadedExamController;
use Illuminate\Support\Facades\Route;

/*
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::middleware(['auth', 'is.reset.one.time'])->group(function () {

############################################################################
##################                                 #########################
##################         admin                   #########################
##################                                 #########################
############################################################################
    Route::middleware(['is.admin'])->group(function () {
        ## certificates
        Route::post('certificates/store', [CertificateController::class, 'store'])->name('certificate_store');

        ## Export
        Route::get('exports/room/attendance/{roomId}', [ExportController::class, 'attendanceExport'])->name('export_attendance');
        Route::get('exports/room/exam/{roomId}', [ExportController::class, 'ExamExport'])->name('export_exam');
        
        ## Report
        Route::get('reports/attendances', [ReportController::class, 'attendances'])->name('report_attendances');
        Route::get('reports/attendances/students/{exam}', [ReportController::class, 'studentAttendance'])->name('report_attendances_students');
        Route::get('reports/exams', [ReportController::class, 'exam'])->name('report_exam');
        Route::get('reports/exams/{roomId}', [ReportController::class, 'studentExam'])->name('report_exam_students');
        Route::get('reports/evaluation', [ReportController::class, 'evaluation'])->name('report_evaluations');
        Route::get('reports/evaluation/{roomId}', [ReportController::class, 'evaluationStudent'])->name('report_evaluation');
        Route::get('reports/all', [ReportController::class, 'allReport'])->name('reports_all');
        Route::get('reports/all/{roomId}', [ReportController::class, 'all'])->name('report_all');

        #Evaluation
        Route::get('evaluations/list', [EvaluationController::class, 'index'])->name('evaluation_list');
        Route::get('evaluations/create', [EvaluationController::class, 'create'])->name('evaluation_create');
        Route::post('evaluations/store', [EvaluationController::class, 'store'])->name('evaluation_store');
        Route::post('evaluations/update', [EvaluationController::class, 'update'])->name('evaluation_update');
        Route::post('evaluations/delete', [EvaluationController::class, 'destroy'])->name('evaluation_delete');
        Route::post('evaluations/toggle', [EvaluationController::class, 'toggle'])->name('evaluation_toggle');
       
        #Evaluation value
        Route::get('evaluation/values/list/{evaluationId}', [EvaluationValueController::class, 'index'])->name('evaluation_value_list');
        Route::post('evaluation/values/store', [EvaluationValueController::class, 'store'])->name('evaluation_value_store');
        Route::post('evaluation/values/update', [EvaluationValueController::class, 'update'])->name('evaluation_value_update');
        Route::post('evaluation/values/delete', [EvaluationValueController::class, 'destroy'])->name('evaluation_value_delete');
        Route::post('evaluation/values/toggle', [EvaluationValueController::class, 'toggle'])->name('evaluation_value_toggle');

        #Exam
        Route::get('exams/list/{evaluationId}', [ExamController::class, 'index'])->name('exam_list');
        Route::get('exams/create', [ExamController::class, 'create'])->name('exam_create');
        Route::post('exams/store', [ExamController::class, 'store'])->name('exam_store');
        Route::post('exams/update', [ExamController::class, 'update'])->name('exam_update');
        Route::post('exams/delete', [ExamController::class, 'destroy'])->name('exam_delete');
        Route::post('exams/toggle', [ExamController::class, 'toggle'])->name('exam_toggle');
        
        #Question
        Route::get('questions/list/{examId}', [QuestionController::class, 'index'])->name('question_list');
        Route::post('questions/store', [QuestionController::class, 'store'])->name('question_store');
        Route::post('questions/update', [QuestionController::class, 'update'])->name('question_update');
        Route::post('questions/delete', [QuestionController::class, 'destroy'])->name('question_delete');
        Route::post('questions/toggle', [QuestionController::class, 'toggle'])->name('question_toggle');

        #classRoom
        Route::post('classes/room/store', [ClassRoomController::class, 'store'])->name('class_room_store');
        Route::post('classes/room/update', [ClassRoomController::class, 'update'])->name('class_room_update');
        Route::post('classes/room/delete', [ClassRoomController::class, 'destroy'])->name('class_room_delete');
        Route::post('classes/room/toggle', [ClassRoomController::class, 'toggle'])->name('class_room_toggle');
        Route::get('classes/room/studentCertificates/{roomId}', [ClassRoomController::class, 'studentCertificate'])->name('class_room_students_certificates');

        #Appendix
        Route::get('appendix/list/{examId}', [AppendixController::class, 'index'])->name('appendix_list');
        Route::post('appendix/store', [AppendixController::class, 'store'])->name('appendix_store');
        Route::post('appendix/update', [AppendixController::class, 'update'])->name('appendix_update');
        Route::post('appendix/delete', [AppendixController::class, 'destroy'])->name('appendix_delete');
        Route::post('appendix/toggle', [AppendixController::class, 'toggle'])->name('appendix_toggle');

        #student

        Route::get('students/list', [StudentsController::class, 'index'])->name('student_list');
        Route::post('students/store', [StudentsController::class, 'store'])->name('student_store');
        Route::post('students/update', [StudentsController::class, 'update'])->name('student_update');
        Route::post('students/delete', [StudentsController::class, 'delete'])->name('student_delete');
        Route::post('students/toggle', [StudentsController::class, 'toggle'])->name('student_toggle');
        Route::post('students/import', [StudentsController::class, 'import'])->name('student_import');

        #trainer

        Route::get('trainers/list', [TrainerController::class, 'index'])->name('trainer_list');
        Route::post('trainers/store', [TrainerController::class, 'store'])->name('trainer_store');
        Route::post('trainers/update', [TrainerController::class, 'update'])->name('trainer_update');
        Route::post('trainers/delete', [TrainerController::class, 'delete'])->name('trainer_delete');
        Route::post('trainers/toggle', [TrainerController::class, 'toggle'])->name('trainer_toggle');
        Route::post('trainers/import', [TrainerController::class, 'import'])->name('trainer_import');
        Route::get('trainers/sendCollection', [TrainerController::class, 'sendCollection'])->name('trainer_send_active');

        #course

        Route::get('courses/list', [CourseController::class, 'index'])->name('course_list');
        Route::post('courses/store', [CourseController::class, 'store'])->name('course_store');
        Route::post('courses/update', [CourseController::class, 'update'])->name('course_update');
        Route::post('courses/delete', [CourseController::class, 'delete'])->name('course_delete');
        Route::post('courses/toggle', [CourseController::class, 'toggle'])->name('course_toggle');

        #lesson

        Route::get('lessons/list/{courseId}', [LessonController::class, 'index'])->name('lesson_list');
        Route::post('lessons/store', [LessonController::class, 'store'])->name('lesson_store');
        Route::post('lessons/update', [LessonController::class, 'update'])->name('lesson_update');
        Route::post('lessons/delete', [LessonController::class, 'delete'])->name('lesson_delete');
        Route::post('lessons/toggle', [LessonController::class, 'toggle'])->name('lesson_toggle');

        #studentsSubscribes

        Route::get('subscribers/{classRoomId}', [StudentSubscribeController::class, 'index'])->name('students_subscribers');
        Route::get('subscribers/create/{classRoomId}', [StudentSubscribeController::class, 'create'])->name('subscribers_crete');
        Route::post('subscribers/store', [StudentSubscribeController::class, 'store'])->name('subscribers_store');
        Route::post('subscribers/delete', [StudentSubscribeController::class, 'delete'])->name('subscribers_delete');

        #attendance

        Route::get('attendances/{classRoomId}/{lessonId}', [AttendanceController::class, 'index'])->name('attendances_list');
        Route::post('attendances/delete', [AttendanceController::class, 'delete'])->name('attendances_delete');
        Route::post('attendances/toggle', [AttendanceController::class, 'toggle'])->name('attendances_toggle');

        #Start dashboard requests
        Route::get('/admin', [DashboardController::class, 'admin'])->name('admin_dash');
        Route::get('/users/users', [DashboardController::class, 'listUser'])->name('users_list');
        Route::post('/users/store', [DashboardController::class, 'store'])->name('user_store');
        Route::post('/users/update', [DashboardController::class, 'update'])->name('user_update');
        Route::post('/users/active', [DashboardController::class, 'toggle'])->name('user_toggle');
        Route::post('/users/delete', [DashboardController::class, 'delete'])->name('user_delete');
        
        #Registration
        Route::get('/generatePassword', [Registration::class, 'generatePassword'])->name('generatePassword');
        Route::get('/sendMails', [Registration::class, 'sendMails'])->name('sendMails');

        #upload file
        Route::post('upload/', [UploadController::class, 'upload'])->name('upload');
        Route::get('delete/{path}', [UploadController::class, 'delete'])->name('delete');

    });

    #notification
    Route::get('/notification/list', [NotificationController::class, 'index']);
    Route::get('/notifications/show/{id}', [NotificationController::class, 'makeNotificationSeen'])->name('make_notification_seen');

    #auth
    Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

    Route::get('/verify', function () {
        return view('auth.verify');
    })->name('verify');

############################################################################
##################                                 #########################
##################           trainer               #########################
##################                                 #########################
############################################################################
    Route::middleware(['is.trainer'])->group(function () {
        Route::get('/trainer', [DashboardController::class, 'trainer'])->name('trainer_dash');
        Route::get('reports/trainer/attendances', [ReportController::class, 'trainerAttendances'])->name('report_trainer_attendances');
        Route::get('reports/trainer/exams', [ReportController::class, 'trainerExam'])->name('report_trainer_exam');
        Route::get('classes/room/list', [ClassRoomController::class, 'index'])->name('class_room_list');
    });

############################################################################
##################                                 #########################
##################         coordinator             #########################
##################                                 #########################
############################################################################
    Route::middleware(['is.coordinator'])->group(function () {
        Route::post('attendances/store', [AttendanceController::class, 'store'])->name('attendances_store');
        Route::get('/coordinator', [DashboardController::class, 'coordinator'])->name('coordinator_dash');
        Route::get('attendances/create/{classRoomId}/{lessonId}', [AttendanceController::class, 'create'])->name('attendances_crete');
    });

    Route::middleware(['can.attendance'])->group(function () {
        Route::get('lessons/attendance/list/{roomId}', [LessonController::class, 'attendancesList'])->name('lesson_attendances_list');
    });

############################################################################
##################                                 #########################
##################           student               #########################
##################                                 #########################
############################################################################
    Route::middleware(['is.student'])->group(function () {
        #studentEvaluation
        Route::get('/evaluation/{subscriberId}', [EvaluationController::class, 'show'])->name('evaluation_show');
        Route::post('students/evaluation/store', [UploadedEvaluationController::class, 'store'])->name('students_evaluation_store');
 
        Route::get('/exam/show/{examId}', [ExamController::class, 'show'])->name('exam_show');
        Route::get('appendix/download/{appendixId}', [AppendixController::class, 'download'])->name('appendix_download');
        #studentExam
        Route::post('students/exam/store', [UploadedExamController::class, 'store'])->name('students_exam_store');
        Route::get('students/exam/list/{roomId}', [UploadedExamController::class, 'list'])->name('students_exam_list');
        Route::get('appendix/listRoom/{roomId}', [AppendixController::class, 'listRoom'])->name('appendix_listRoom');
        Route::get('/student', [DashboardController::class, 'index'])->name('user_dash');
        Route::get('certificates/spent/{certificateId}', [CertificateController::class, 'spent'])->name('get_certificate');
        Route::get('/standingClasses', [DashboardController::class, 'standingClasses'])->name('standingClasses');
        Route::get('/completedClasses', [DashboardController::class, 'completedClasses'])->name('completedClasses');
    });

});

#Login
Route::post('/login', [LoginController::class, 'login'])->name('logins');
Route::get('/',
    function () {
        return view('auth.login');
    })->name('login')->middleware('guest');

#Reset
Route::get('/reset/{email}/{password}', [Registration::class, 'reset'])->name('reset');
Route::get('reset/password',
    function () {
        return view('auth.reset-password');
    })->name('resetPasswordView')->middleware('auth');
Route::post('reset/password', [AuthController::class, 'resetPassword'])->name('resetPassword')->middleware('auth');
